/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.tr7zw.notenoughanimations.config.Config;
import dev.tr7zw.notenoughanimations.config.ConfigUpgrader;
import dev.tr7zw.notenoughanimations.logic.ArmTransformer;
import dev.tr7zw.notenoughanimations.logic.HeldItemHandler;
import dev.tr7zw.notenoughanimations.logic.RotationFixer;
import dev.tr7zw.transliterationlib.api.TRansliterationLib;
import dev.tr7zw.transliterationlib.api.event.APIEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public abstract class NEAnimationsLoader {
    public static NEAnimationsLoader INSTANCE;
    public static Config config;
    private final File settingsFile = new File("config", "notenoughanimations.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public void onEnable() {
        INSTANCE = this;
        if (this.settingsFile.exists()) {
            try {
                config = (Config)this.gson.fromJson(new String(Files.readAllBytes(this.settingsFile.toPath()), StandardCharsets.UTF_8), Config.class);
            }
            catch (Exception ex) {
                System.out.println("Error while loading config! Creating a new one!");
                ex.printStackTrace();
            }
        }
        if (config == null) {
            config = new Config();
            this.writeConfig();
        } else if (ConfigUpgrader.upgradeConfig(config)) {
            this.writeConfig();
        }
        if (TRansliterationLib.transliteration != null) {
            this.enable();
        } else {
            APIEvent.LOADED.register(() -> this.enable());
        }
    }

    private void enable() {
        new RotationFixer().enable();
        new ArmTransformer().enable();
        new HeldItemHandler().enable();
    }

    public void writeConfig() {
        if (this.settingsFile.exists()) {
            this.settingsFile.delete();
        }
        try {
            Files.write(this.settingsFile.toPath(), this.gson.toJson((Object)config).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

